unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleServer, ExcelXP, ComObj, ComCtrls;

type
  TForm1 = class(TForm)
    ExcelApplication1: TExcelApplication;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    TreeView1: TTreeView;
    Button7: TButton;
    Button8: TButton;
    SaveDialog1: TSaveDialog;
    Button9: TButton;
    TreeView2: TTreeView;
    procedure Button9Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var komunikat :String;
begin
ExcelApplication1.Connect;

with ExcelApplication1 do
begin
komunikat:='Aktywny zeszyt: '+ActiveWorkbook.Name +Chr(10)+
           'Aktywny arkusz: '+(ActiveSheet as ExcelWorksheet).Name +Chr(10)+
           'Adres aktywnego pola: '+ActiveCell.Address[True,True,1,False,False] +Chr(10)+
           'Warto aktywnego pola: '+String(ActiveCell.Value2);

end;
MessageBox(Handle,PChar(komunikat),'Informacje o aktualnie uruchomionej aplikacji Excela',IDOK);
ExcelApplication1.Disconnect;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  ExlApp :Variant; //Deklaracja obiektu Excela jako wariant
  komunikat :String;
begin
//Tu obiekt nie jest tworzony, a jedynie do zmiennej przypisywany jest
//obiekt istniejacy (uruchomiona aplikacja Excela)
try
   ExlApp:=GetActiveOleObject('Excel.Application');
except
   on EOleSysError do
      begin
      ShowMessage('Bd! Nie udao si podczy do Excela.');
      Exit;
      end;
end;

//Informacja o aktywnym skoroszycie, arkuszu i komrce
komunikat:='Aktywny zeszyt: '+ExlApp.ActiveWorkbook.Name +Chr(10)+
           'Aktywny arkusz: '+ExlApp.ActiveSheet.Name +Chr(10)+
           'Adres aktywnego pola: '+ExlApp.ActiveCell.Address +Chr(10)+
           'Warto aktywnego pola: '+String(ExlApp.ActiveCell.Value);
MessageBox(Handle,PChar(komunikat),
'Informacje o aktualnie uruchomionej aplikacji Excela',MB_OK);
ExlApp:=Null;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
ExcelApplication1.Quit;
end;

procedure TForm1.Button4Click(Sender: TObject);
var ExlApp :Variant; //Deklaracja obiektu Excela jako wariant
begin
ExlApp:=GetActiveOleObject('Excel.Application'); //Przypisanie
if not VarIsEmpty(ExlApp) then
   ExlApp.Quit; //Wykorzystanie funkcji Excela
ExlApp:=Null;
end;

procedure TForm1.Button5Click(Sender: TObject);
var ExlApp :Variant;
begin
ExlApp:=CreateOleObject('Excel.Application');
if VarIsEmpty(ExlApp) then Exit;

ExlApp.Visible:=True;
ExlApp.Workbooks.Add;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  ExlApp :Variant; //Deklaracja obiektu Excela jako wariant
  n,m :Integer;
  wezel :TTreeNode;
begin
//Przypisanie
ExlApp:=GetActiveOleObject('Excel.Application');

//Czyszczenie listy
TreeView1.Items.Clear;

for n:=1 to ExlApp.Workbooks.Count do //Petla po zeszytach
  begin
  wezel:=TreeView1.Items.AddFirst(nil,ExlApp.Workbooks[n].Name);
  for m:=1 to ExlApp.Workbooks[n].Sheets.Count do //Arkusze
    TreeView1.Items.AddChild(wezel,ExlApp.Workbooks[n].Sheets[m].Name);
  end;

//Zwolnienie zmiennej
ExlApp:=Null;
end;

procedure TForm1.Button7Click(Sender: TObject);
var
  ExlApp :Variant;
  NazwaPliku :String;
begin
ExlApp:=GetActiveOleObject('Excel.Application'); //Przypisanie
NazwaPliku:='';
while NazwaPliku='' do
      NazwaPliku:=ExlApp.GetSaveAsFilename(NazwaPliku); //Okno dialogowe Excela
ExlApp.ActiveWorkbook.SaveAs(NazwaPliku);
//Trzeba pamietac o rozszerzeniu .xls w nazwie pliku
end;

procedure TForm1.Button8Click(Sender: TObject);
var
  ExlApp :Variant;
begin
ExlApp:=GetActiveOleObject('Excel.Application'); //Przypisanie
SaveDialog1.FileName:='';
if SaveDialog1.Execute then
  ExlApp.ActiveWorkbook.SaveAs(SaveDialog1.FileName);
end;

procedure TForm1.Button9Click(Sender: TObject);
var
  n,m :Integer;
  wezel :TTreeNode;
begin
ExcelApplication1.Connect;
TreeView2.Items.Clear;

for n:=1 to ExcelApplication1.Workbooks.Count do //Petla po zeszytach
  begin
  wezel:=TreeView2.Items.AddFirst(nil,ExcelApplication1.Workbooks[n].Name);
  for m:=1 to ExcelApplication1.Workbooks[n].Sheets.Count do //Arkusze
    TreeView2.Items.AddChild(wezel,(ExcelApplication1.Workbooks[n].Sheets[m] as ExcelWorksheet).Name);
  end;

ExcelApplication1.Disconnect;
end;

end.
